;; This example shows the standard way to use
;; interrupt mode 2. i.e. when there is a device
;; connected that will generate a predictable 8-bit vector.
;;
;; This example uses the CPC+ vector interrupts.
;;
;; (c) Kevin Thacker, 2001-2002
;;
;; This source is released under the GNU Public License v2.

org &8000
nolist


;;--------------------------------------------------
;; unlock asic to gain access to asic registers
di
ld b,&bc
ld hl,sequence
ld e,17
.seq 
ld a,(hl)
out (c),a
inc hl
dec e
jr nz,seq

;;--------------------------------------------------
;; initialise bits 7..3 of 8-bit vector provided by ASIC

;; page-in asic registers
ld bc,&7fb8
out (c),c

;; set bits 7..3 of 8-bit interrupt vector to "0" and do not automatically clear interrupts.
;; bit 0 -  if "0", automatically clear interrupts. 
;; ASIC will automatically setup bits 2..1 dependant on interrupt source.
;;
;; when bits 7..3 of 8-bit interrupt vector are "0", the vector generated by the ASIC
;; will be 0,2,4 or 6 only.
;;
;; Do not use automatic clearing of interrupts, because there is a bug!

ld a,1
ld (&6805),a						;; IVR register

;; page-out asic registers
ld bc,&7fa8
out (c),c

ei


;;--------------------------------------------------
;; initialise interrupt handler - required
;; disable interrupts
di

;; set interrupt mode 2
im 2

;; set I register. This is the most significant byte
;; of the address of the interrupt handler table and forms 
;; bit 15..8 of the lookup address.
;; The table covers the range &9000-&9100 inclusive.
ld a,&90
ld i,a

;; The CPC+ has 4 interrupt sources:
;; raster interrupt, dma channel 0, dma channel 1 and dma channel 2
;;
;; The CPC+ will generate a 8-bit vector to identify the source
;; of the interrupt.

;; this will initialise the table specifically for the CPC+
;; if you were using another device, then you would put
;; your table initialisation code here.
ld hl,interrupt_handlers
ld de,&9000
ld bc,end_interrupt_handlers-interrupt_handlers
ldir

;; enable interrupts

ei

;;----------------------------------------------------------
;; this is some example code to show so the example can be assembled
;; and run. This is not required and you can change this with
;; your own code.


;;----------------------------------------------------------

;; this table defines the interrupt handlers and is used
;; to setup the im 2 interrupt handler table at &9000
.interrupt_handlers
defw interrupt_handler1			;; dma channel 2
defw interrupt_handler2			;; dma channel 1
defw interrupt_handler3			;; dma channel 0
defw interrupt_handler4			;; raster interrupts
.end_interrupt_handlers	

;;----------------------------------------------------------
;; interrupt handler for dma channel 2

.interrupt_handler1
ei
reti

;;----------------------------------------------------------
;; interrupt handler for dma channel 1

.interrupt_handler2
ei
reti

;;----------------------------------------------------------
;; interrupt handler for dma channel 0

.interrupt_handler3
ei
reti

;;----------------------------------------------------------
;; interrupt handler for raster interrupts

.interrupt_handler4
ei
reti

;;----------------------------------------------------------
;; this is the sequence to unlock the ASIC extra features
.sequence
defb &ff,&00,&ff,&77,&b3,&51,&a8,&d4,&62,&39,&9c,&46,&2b,&15,&8a,&cd,&ee
